# get details from the command line
$sDetails = $args[0]

# smtp server
$emailSmtpServer = "smtp.MYSERVER.com"
$emailSmtpServerPort = "587"

# sender and recipient info
$emailFrom = "me@yourdomain.com"
$emailTo = "you@yourdomain.com,archer.logs@bitsight.com"

# message
$cwd = Get-Location
$emailMessage = New-Object System.Net.Mail.MailMessage( $emailFrom , $emailTo )
$emailMessage.Subject = "BitSight Nightly Script Error"
$emailMessage.IsBodyHtml = $true
$emailMessage.Body = "<h2>Error Running BitSight Nightly Script</h2>"
$emailMessage.Body += "<b>Details from Script:</b><br>" + $sDetails
$emailMessage.Body += "<br><br>Next Steps: Review logs for details"
$emailMessage.Body += "<br>Log Location: $cwd\\logs"

#Due to the large size of the nightly files, we are not attaching them by default.
#Uncomment the lines below if you want to send the logs.
#Note: a BitSight Portfolio of 10,000 active companies using verbose logging will result in a log about 500mb in size.
#Just make sure to review/obtain the logs before the next nightly job is run.

#$attachmentPath = "$cwd\\logs\\200-BitSightSubscriptions.log"
#$attach = New-Object System.Net.Mail.Attachment($attachmentPath) 
#$emailMessage.Attachments.Add($attach)

#$attachmentPath = "$cwd\\logs\\210-BitSightGetHeadlineRatingsNightly.log"
#$attach = new-object Net.Mail.Attachment($attachmentPath) 
#$emailMessage.Attachments.Add($attach)

#$attachmentPath = "$cwd\\logs\\220-PublicDisclosures.log"
#$attach = new-object Net.Mail.Attachment($attachmentPath) 
#$emailMessage.Attachments.Add($attach)

#$attachmentPath = "$cwd\\logs\\220-PublicDisclosures-20220326Fail.log"
#$attach = new-object Net.Mail.Attachment($attachmentPath) 
#$emailMessage.Attachments.Add($attach)


# client 
$SMTPClient = New-Object System.Net.Mail.SmtpClient( $emailSmtpServer , $emailSmtpServerPort )

###UNCOMMENT if your email server requires SSL
$SMTPClient.EnableSsl = $True

###UNCOMMENT and set data if your email server requires credentials
#$emailSmtpUser = "emailUser"


#Shouldn't need this since I was able to use the secure pass in PowerShell using this: Read-Host "Enter Password" -AsSecureString | ConvertFrom-SecureString
#$emailSmtpPass = 'emailPassword'

#The line below uses the secure string and that is passed in.
#$emailSmtpPass = "SECURE_STRING" | ConvertTo-SecureString

$SMTPClient.Credentials = New-Object System.Net.NetworkCredential( $emailSmtpUser , $emailSmtpPass );


# send the email
$SMTPClient.Send( $emailMessage )
